/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.common.util;

import de.joergjahnke.common.util.Observable;
import de.joergjahnke.common.util.Observer;
import java.util.Vector;

public class DefaultObservable
implements Observable {
    private final Vector observers = new Vector();
    private boolean hasChanged = false;
    private final Object observed;

    public DefaultObservable() {
        this.observed = this;
    }

    public DefaultObservable(Object observed) {
        this.observed = observed;
    }

    @Override
    public void addObserver(Observer o) {
        if (!this.observers.contains(o)) {
            this.observers.addElement(o);
        }
    }

    @Override
    public void deleteObserver(Observer o) {
        this.observers.removeElement(o);
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    @Override
    public void notifyObservers(Object arg) {
        if (this.hasChanged()) {
            int i = 0;
            int to = this.observers.size();
            while (i < to) {
                ((Observer)this.observers.elementAt(i)).update(this.observed, arg);
                ++i;
            }
            this.setChanged(false);
        }
    }

    @Override
    public void deleteObservers() {
        this.observers.removeAllElements();
    }

    @Override
    public void setChanged(boolean state) {
        this.hasChanged = state;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public int countObservers() {
        return this.observers.size();
    }
}

